/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.userprof;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.userprof.RoleItem;
import com.ibm.hwmca.base.userprof.RoleTree;
import com.ibm.hwmca.base.userprof.UserAttributes;
import com.ibm.hwmca.base.userprof.UserProfSaveRestore;
import com.ibm.hwmca.base.userprof.UserProfilesException;
import com.ibm.hwmca.base.userprof.UserProfilesPlugin;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.CustomizedUserRole;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectGroup;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.managed.TaskGroup;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.managed.UserDefinedTaskGroup;
import com.ibm.hwmca.fw.managed.UserRole;
import com.ibm.hwmca.fw.tasklet.xport.TaskletController;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class UserProfilesPluginImpl
implements UserProfilesPlugin {
    private static final String TRACE_MASKF = "USRIMPSF";
    private static final String TRACE_MASKT = "USRIMPST";
    private static final String TRACE_MASKD = "USRIMPSD";
    private int idCounter = 0;
    private ClassId userClassId = new ClassId(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = UserProfilesPluginImpl.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User);
    private ClassId userRoleClassId = new ClassId(class$com$ibm$hwmca$fw$managed$UserRole == null ? (class$com$ibm$hwmca$fw$managed$UserRole = UserProfilesPluginImpl.class$("com.ibm.hwmca.fw.managed.UserRole")) : class$com$ibm$hwmca$fw$managed$UserRole);
    private ClassId managedObjectClassId = new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UserProfilesPluginImpl.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject);
    private ClassId managedObjectGroupClassId = new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = UserProfilesPluginImpl.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup);
    ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    boolean caseSensitivity = false;
    private boolean multipleTaskRoles = true;
    private boolean multipleManagedResourceRoles = true;
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    private static String customDataKey = new UserProfSaveRestore().getCustomDataKey();
    private boolean remoteAccessApplies = true;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$User;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$UserRole;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;

    public UserAttributes[] getUsers() {
        User obj;
        Trace.trace(TRACE_MASKT, "-> getUsers ");
        Set inventory = this.getProfilesInventory(this.userClassId, 0);
        TreeMap<String, User> realUsers = new TreeMap<String, User>();
        int i = 0;
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            obj = (User)iterator.next();
            if (!obj.isDisplayable()) continue;
            ++i;
        }
        UserAttributes[] users = new UserAttributes[i];
        i = 0;
        Iterator iterator2 = inventory.iterator();
        while (iterator2.hasNext()) {
            obj = (User)iterator2.next();
            if (!obj.isDisplayable()) continue;
            realUsers.put(obj.getUIInfo().getTitle(), obj);
        }
        users = this.buildUsers(realUsers, users, i);
        Trace.trace(TRACE_MASKT, "< getUsers " + users.length);
        return users;
    }

    public UserAttributes getUser(String userid) {
        Trace.trace(TRACE_MASKT, "-> getUser(userid) " + userid);
        User curUser = User.getUser(userid);
        LocalizableText desc = new LocalizableText(curUser.getUIInfo().getCaption());
        UserAttributes curUserAtt = new UserAttributes(userid, curUser.getPassword(), desc);
        curUserAtt = this.buildRoles(curUserAtt, curUser);
        if (curUser.isPasswordRulesEnforced()) {
            curUserAtt.setPasswordRulesEnforced(curUser.isPasswordRulesEnforced());
            curUserAtt.setPasswordExpiration(curUser.getPasswordExpiration());
        } else {
            curUserAtt.setPasswordRulesEnforced(curUser.isPasswordRulesEnforced());
        }
        curUserAtt.setEditable(curUser.isEditable());
        if (this.remoteAccessApplies) {
            curUserAtt.setRemoteAccess(curUser.isRemoteAccessPermitted());
        } else {
            curUserAtt.setRemoteAccess(false);
        }
        Trace.trace(TRACE_MASKT, "<- getUser");
        return curUserAtt;
    }

    public void addUser(UserAttributes userAttr) {
        Trace.trace(TRACE_MASKT, "-> addUser ");
        byte[] bytePW = userAttr.getPassword();
        String password = new String(bytePW);
        String userName = userAttr.getUserid();
        boolean result = false;
        Date today = new Date();
        UIInfo uiInfo = new UIInfo(new LocalizableText(userAttr.getUserid()), userAttr.getDescription());
        User myUser = this.caseSensitivity ? new User(userName, password, uiInfo) : new User(userName, password.toUpperCase(), uiInfo);
        myUser.setCaseSensitive(false);
        myUser.setEditable(true);
        myUser.setDisplayable(true);
        if (userAttr.getPasswordExpiration() > 0) {
            myUser.setPasswordExpiration(userAttr.getPasswordExpiration());
            myUser.setPasswordRulesEnforced(true);
            myUser.setExpirationStartDate(today.getTime());
        }
        if (this.remoteAccessApplies) {
            myUser.setRemoteAccess(userAttr.isRemoteAccessPermitted());
        } else {
            myUser.setRemoteAccess(false);
        }
        this.mom.add(myUser);
        List moRoles = userAttr.getRoles(0);
        List taskRoles = userAttr.getRoles(1);
        for (int i = 0; i < moRoles.size(); ++i) {
            ObjectId anId = (ObjectId)moRoles.get(i);
            myUser.addUserRole((UserRole)this.getProfilesObj(anId));
        }
        for (int l = 0; l < taskRoles.size(); ++l) {
            ObjectId tId = (ObjectId)taskRoles.get(l);
            myUser.addUserRole((UserRole)this.getProfilesObj(tId));
        }
        this.logUserEvent(0, myUser.getUIInfo().getName().toString());
        Trace.trace(TRACE_MASKT, "<- addUser ");
    }

    public void modifyUser(UserAttributes userAttr) {
        Date today = new Date();
        Trace.trace(TRACE_MASKT, "-> modifyUser ");
        String password = null;
        byte[] bytePW = userAttr.getPassword();
        if (bytePW != null) {
            password = new String(bytePW);
        }
        User myUser = User.getUser(userAttr.getUserid());
        UIInfo uiInfo = new UIInfo(new LocalizableText(userAttr.getUserid()), userAttr.getDescription());
        myUser.setUIInfo(uiInfo);
        if (this.remoteAccessApplies) {
            myUser.setRemoteAccess(userAttr.isRemoteAccessPermitted());
        } else {
            myUser.setRemoteAccess(false);
        }
        if (userAttr.getPasswordExpiration() > 0) {
            myUser.setPasswordExpiration(userAttr.getPasswordExpiration());
            myUser.setPasswordRulesEnforced(true);
            myUser.setExpirationStartDate(today.getTime());
        } else {
            myUser.setPasswordRulesEnforced(false);
            myUser.setPasswordExpiration(0);
        }
        if (password != null) {
            myUser.setPassword(new String(userAttr.getPassword()));
            if (myUser.hasAuth("base.rolegroup.service")) {
                UserProfilesException exc = new UserProfilesException(new BaseMessageText("ADM0028"));
                exc.setMsgType(MsgType.INFORMATION_MESSAGE);
                throw exc;
            }
        }
        myUser.removeAllUserRoles();
        List moRoles = userAttr.getRoles(0);
        List taskRoles = userAttr.getRoles(1);
        for (int i = 0; i < moRoles.size(); ++i) {
            ObjectId anId = (ObjectId)moRoles.get(i);
            myUser.addUserRole((UserRole)this.getProfilesObj(anId));
        }
        for (int l = 0; l < taskRoles.size(); ++l) {
            ObjectId tId = (ObjectId)taskRoles.get(l);
            myUser.addUserRole((UserRole)this.getProfilesObj(tId));
        }
        this.logUserEvent(1, myUser.getUIInfo().getName().toString());
        Trace.trace(TRACE_MASKT, "<- modifyUser ");
    }

    public void removeUser(String userid) {
        Trace.trace(TRACE_MASKT, "-> removeUser(userid) " + userid);
        User myUser = User.getUser(userid);
        HwmcaObject target = this.getProfilesObj(myUser.getObjectId());
        if (target != null) {
            target.unpersist();
            this.mom.remove(target.getObjectId());
        } else {
            Trace.trace(TRACE_MASKT, "removeUser target is null - bad news ");
        }
        this.logUserEvent(2, myUser.getUIInfo().getName().toString());
        Trace.trace(TRACE_MASKT, "<- removeUser(userid) ");
    }

    public List getRoles(int type) {
        List curRoles = new ArrayList();
        TreeMap<String, HwmcaObject> realObjects = new TreeMap<String, HwmcaObject>();
        Trace.trace(TRACE_MASKT, "-> getRoles(type) " + type);
        Set inventory = this.getProfilesInventory(this.userRoleClassId, 0);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            if (!((UserRole)obj).isDisplayable() || type != ((UserRole)obj).getType()) continue;
            realObjects.put(obj.getUIInfo().getTitle(), obj);
        }
        curRoles = this.buildObjects(realObjects, type, curRoles, 0);
        Trace.trace(TRACE_MASKT, "<- getRoles(type) ");
        return curRoles;
    }

    public Object addRole(RoleTree role) {
        Trace.trace(TRACE_MASKT, "-> addRole(role) ");
        Set newObjects = new HashSet();
        LocalizableText name = role.getName();
        UIInfo uiInfo = new UIInfo(name, name);
        try {
            CustomizedUserRole customRole = new CustomizedUserRole(name.toString(), uiInfo);
            customRole.setType(role.getType());
            customRole.setDisplayable(true);
            customRole.setEditable(true);
            RoleTree basedRole = role.getBasedOnRole();
            customRole.setBasedOnRole((ObjectId)basedRole.getKey());
            Trace.trace(TRACE_MASKT, "basedonRole is " + customRole.getBasedOnRole());
            this.mom.add(customRole);
            newObjects = this.buildObjectList(customRole, role);
            customRole.setPermittedObjects(newObjects);
            this.logRoleEvent(0, name.toString());
            Trace.trace(TRACE_MASKT, "<- addRole roleSize is " + customRole.getPermittedObjects());
            TaskletController.flushCache();
            return customRole.getObjectId();
        }
        catch (Exception e) {
            throw new UserProfilesException(new BaseMessageText("ADM0026"));
        }
    }

    public void removeRole(RoleTree role) {
        Trace.trace(TRACE_MASKT, "-> removeRole(role) ");
        HashSet permittedObjects = new HashSet();
        HwmcaObject target = this.getProfilesObj((ObjectId)role.getKey());
        if (target != null) {
            if (target instanceof CustomizedUserRole) {
                Iterator j = ((CustomizedUserRole)target).getPermittedObjects().iterator();
                while (j.hasNext()) {
                    HwmcaObject myObj;
                    ClassId elem = (ClassId)j.next();
                    if (!(elem instanceof ObjectId) || (myObj = this.getProfilesObj((ObjectId)elem)) == null || !(myObj instanceof UserDefinedTaskGroup)) continue;
                    myObj.unpersist();
                    this.mom.remove(myObj.getObjectId());
                }
            }
            target.unpersist();
            this.mom.remove(target.getObjectId());
        } else {
            Trace.trace(TRACE_MASKT, "removeUser target is null - bad news ");
        }
        this.logRoleEvent(2, role.getName().toString());
        Trace.trace(TRACE_MASKT, "<- removeRole(role) ");
    }

    public void modifyRole(RoleTree role) {
        Trace.trace(TRACE_MASKT, "-> modifyRoles(role) ");
        Set newObjects = new HashSet();
        HwmcaObject target = this.getProfilesObj((ObjectId)role.getKey());
        if (target != null && target instanceof CustomizedUserRole) {
            newObjects = this.buildObjectList((CustomizedUserRole)target, role);
            ((CustomizedUserRole)target).setPermittedObjects(newObjects);
        }
        this.logRoleEvent(1, role.getName().toString());
        Trace.trace(TRACE_MASKT, "<- modifyRole(role) ");
    }

    public Set getProfilesInventory(ClassId classId, int path) {
        Trace.trace(TRACE_MASKT, " <> getProfileInventory()" + classId);
        if (path == 0) {
            return this.mom.getInventory(classId);
        }
        return this.mom.getInventoryObjectIds(classId);
    }

    public HwmcaObject getProfilesObj(ObjectId objectId) {
        Trace.trace(TRACE_MASKT, " <> getProfileObj.getProfileObj()" + objectId);
        return this.mom.get(objectId);
    }

    public RoleTree findRoleTree(List curRoles, ObjectId treeId) {
        RoleTree curTree = null;
        Trace.trace(TRACE_MASKT, "-> findRoleTree curRoles.size()" + curRoles.size());
        Trace.trace(TRACE_MASKT, "treeId " + treeId);
        for (int i = 0; i < curRoles.size(); ++i) {
            curTree = (RoleTree)curRoles.get(i);
            if (!curTree.getKey().equals(treeId)) continue;
            i = curRoles.size();
            return curTree;
        }
        Trace.trace(TRACE_MASKT, "<- findRoleTree ");
        return curTree;
    }

    public UserAttributes buildRoles(UserAttributes curUserAttr, User curUser) {
        Trace.trace(TRACE_MASKT, "--> buildRoles ");
        Set userRoles = curUser.getUserRoles();
        ArrayList<RoleTree> moRoles = new ArrayList<RoleTree>();
        ArrayList<RoleTree> taskRoles = new ArrayList<RoleTree>();
        Iterator iterator = userRoles.iterator();
        while (iterator.hasNext()) {
            UserRole curRole = (UserRole)iterator.next();
            LocalizableText desc = new LocalizableText(curRole.getUIInfo().getTitle());
            RoleTree myTree = new RoleTree(curRole.getObjectId(), desc, null);
            if (curRole.isManagedObjectRole()) {
                if (!curRole.isDisplayable()) continue;
                moRoles.add(myTree);
                continue;
            }
            if (!curRole.isDisplayable()) continue;
            taskRoles.add(myTree);
        }
        curUserAttr.setRoles(0, moRoles);
        curUserAttr.setRoles(1, taskRoles);
        Trace.trace(TRACE_MASKT, "<-- buildRoles ");
        return curUserAttr;
    }

    public List getFullRoles(int type) {
        List curRoles = new ArrayList();
        ArrayList customizedObjects = new ArrayList();
        TreeMap<String, HwmcaObject> realObjects = new TreeMap<String, HwmcaObject>();
        Trace.trace(TRACE_MASKT, "-> getFullRoles(type) " + type);
        Set inventory = this.getProfilesInventory(this.userRoleClassId, 0);
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            if (!((UserRole)obj).isDisplayable() || type != ((UserRole)obj).getType()) continue;
            realObjects.put(obj.getUIInfo().getTitle(), obj);
        }
        curRoles = this.buildObjects(realObjects, type, curRoles, 1);
        Trace.trace(TRACE_MASKT, "<- getFullRoles(type) ");
        return curRoles;
    }

    public RoleTree buildManagedObjectGroups(RoleTree myTree, UserRole role) {
        boolean titleAdded = false;
        TreeMap<String, ManagedObjectGroup> curGroups = new TreeMap<String, ManagedObjectGroup>();
        Set managedGroups = this.getProfilesInventory(this.managedObjectGroupClassId, 1);
        String value = this.createKey(new ObjectId(this.managedObjectGroupClassId.toString()));
        RoleItem myItem = new RoleItem(value, new LocalizableText(this.managedObjectGroupClassId.getClassName()));
        myItem.setPermissionItem(false);
        Iterator iterator = managedGroups.iterator();
        while (iterator.hasNext()) {
            ManagedObjectGroup groupObject;
            ObjectId elem = (ObjectId)iterator.next();
            if (!role.isObjectPermitted(elem)) continue;
            if (!titleAdded) {
                myTree.add(myItem);
                titleAdded = true;
            }
            if ((groupObject = (ManagedObjectGroup)this.getProfilesObj(elem)) == null) continue;
            curGroups.put(groupObject.getUIInfo().getTitle(), groupObject);
        }
        this.buildObjectGroups(curGroups, myItem);
        return myTree;
    }

    public RoleTree buildManagedObjects(RoleTree myTree, UserRole role) {
        boolean titleAdded = false;
        TreeMap<String, ManagedObject> curObjects = new TreeMap<String, ManagedObject>();
        Set managedObjects = this.getProfilesInventory(this.managedObjectClassId, 1);
        String value = this.createKey(new ObjectId(this.managedObjectClassId.toString()));
        RoleItem myItem = new RoleItem(value, new LocalizableText(this.managedObjectClassId.getClassName()));
        myItem.setPermissionItem(false);
        Iterator iterator = managedObjects.iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject;
            ObjectId elem = (ObjectId)iterator.next();
            if (!role.isObjectPermitted(elem)) continue;
            if (!titleAdded) {
                myTree.add(myItem);
                titleAdded = true;
            }
            if ((managedObject = (ManagedObject)this.getProfilesObj(elem)) == null) continue;
            curObjects.put(managedObject.getUIInfo().getTitle(), managedObject);
        }
        this.buildChildObjects(curObjects, myItem);
        return myTree;
    }

    public RoleTree buildTaskObjects(RoleTree myTree, UserRole role) {
        ArrayList curTasksGroups = new ArrayList();
        ArrayList curTasks = new ArrayList();
        Trace.trace(TRACE_MASKT, "-> buildTaskObjects roleName " + role.getName());
        Set permittedObjects = role.getPermittedObjects();
        Trace.trace(TRACE_MASKT, "permittedObject size in buildTaskObjects is " + permittedObjects.size());
        Iterator j = role.getPermittedObjects().iterator();
        while (j.hasNext()) {
            HwmcaObject myObj;
            ClassId elem = (ClassId)j.next();
            if (!(elem instanceof ObjectId) || (myObj = this.getProfilesObj((ObjectId)elem)) == null || !(myObj instanceof TaskGroup) || !myObj.isRoot()) continue;
            LocalizableText name = myObj.getUIInfo().getUnlocalizedName();
            String value = this.createKey((ObjectId)elem);
            RoleItem myItem = new RoleItem(value, name);
            myItem.setPermissionItem(true);
            myTree.add(myItem);
            this.getTaskChildren((TaskGroup)myObj, myItem, role);
        }
        Trace.trace(TRACE_MASKT, "<- buildTaskObjects myTree size is " + myTree.getChildCount());
        return myTree;
    }

    public void getTaskChildren(TaskGroup parentTaskGroup, RoleItem roleTree, UserRole curRole) {
        Trace.trace(TRACE_MASKT, "-> getTaskChildren ");
        List children = parentTaskGroup.getChildren();
        children = this.orderInventory(children);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            RoleItem uiObject;
            String value;
            String name;
            HwmcaObject nextObject;
            ObjectId nextId = (ObjectId)iterator.next();
            if (!curRole.isObjectPermitted(nextId) || (nextObject = this.getProfilesObj(nextId)) == null) continue;
            if (nextObject instanceof TaskGroup) {
                TaskGroup group = (TaskGroup)nextObject;
                name = group.getUIInfo().getTitle();
                value = this.createKey(nextId);
                uiObject = new RoleItem(value, new LocalizableText(name));
            } else {
                Task task = (Task)nextObject;
                name = task.getUIInfo().getTitle();
                value = this.createKey(nextId);
                uiObject = new RoleItem(value, new LocalizableText(name));
            }
            roleTree.add(uiObject);
            if (!(nextObject instanceof TaskGroup)) continue;
            this.getTaskChildren((TaskGroup)nextObject, uiObject, curRole);
        }
        Trace.trace(TRACE_MASKT, "<- getTaskChildren ");
    }

    public String createKey(ObjectId elem) {
        String value = String.valueOf(this.idCounter);
        value = value.concat("-");
        value = value.concat(elem.toString());
        ++this.idCounter;
        return value;
    }

    private void logUserEvent(int path, String userName) {
        String[] subst = new String[2];
        subst[0] = userName;
        if (path == 0) {
            FrameworkEventText fet = new FrameworkEventText(115, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "PROFADD");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "PROFADD");
            e4EventLog.log();
        } else if (path == 1) {
            FrameworkEventText fet = new FrameworkEventText(116, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "PROFCHG");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "PROFCHG");
            e4EventLog.log();
        } else {
            FrameworkEventText fet = new FrameworkEventText(118, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "PROFDEL");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "PROFDEL");
            e4EventLog.log();
        }
        if (dataRepApp.isDataRepEnabled()) {
            dataRepApp.updateCustomDataLevel(customDataKey);
        }
    }

    private void logRoleEvent(int path, String roleName) {
        String[] subst = new String[2];
        subst[0] = roleName;
        if (path == 0) {
            FrameworkEventText fet = new FrameworkEventText(1203, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "ROLEADD");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "ROLEADD");
            e4EventLog.log();
        } else if (path == 1) {
            FrameworkEventText fet = new FrameworkEventText(1204, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "ROLECHG");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "ROLECHG");
            e4EventLog.log();
        } else {
            FrameworkEventText fet = new FrameworkEventText(1205, subst);
            SystemEventLog logEvent = new SystemEventLog(fet, "ROLEDEL");
            logEvent.log();
            E4EventLog e4EventLog = new E4EventLog(fet, "ROLEDEL");
            e4EventLog.log();
        }
        if (dataRepApp.isDataRepEnabled()) {
            dataRepApp.updateCustomDataLevel(customDataKey);
        }
    }

    public boolean allowMultipleTaskRoles() {
        return this.multipleTaskRoles;
    }

    public boolean allowMultipleManagedResourceRoles() {
        return this.multipleManagedResourceRoles;
    }

    public boolean getDefaultCaseSensitivity() {
        return this.caseSensitivity;
    }

    public boolean getDefaultRemoteAccess() {
        return this.remoteAccessApplies;
    }

    public void validateUserid(String name) {
        Trace.trace(TRACE_MASKT, "-> validateUserid " + name);
        int result = 0;
        result = UserProfilesPluginImpl.isUseridValid(name);
        if (result == 0) {
            if (name.equals("pedebug") || name.equals("PEDEBUG")) {
                throw new UserProfilesException(new BaseMessageText("ADM0005"));
            }
            Set inventory = this.getProfilesInventory(this.userClassId, 0);
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                User obj = (User)iterator.next();
                if (!(this.caseSensitivity ? obj.getUserName().equals(name) : obj.getUserName().equalsIgnoreCase(name))) continue;
                throw new UserProfilesException(new BaseMessageText("ADM0005"));
            }
        } else {
            if (result == 1) {
                throw new UserProfilesException(new BaseMessageText("HACA000M"));
            }
            if (result == 2) {
                throw new UserProfilesException(new BaseMessageText("HACA000N"));
            }
        }
    }

    public void validatePassword(String password, boolean m_bEnforcePassword) {
        Trace.trace(TRACE_MASKT, "-> validatePassword " + password + " " + m_bEnforcePassword);
        int results = 0;
        String[] s = new String[1];
        if (m_bEnforcePassword) {
            results = this.caseSensitivity ? UserProfilesPluginImpl.isPasswordValid(password) : UserProfilesPluginImpl.isPasswordValid(password.toUpperCase());
            if (results > 0) {
                if (results == 1) {
                    throw new UserProfilesException(new BaseMessageText("HACA0003"));
                }
                if (results == 2) {
                    throw new UserProfilesException(new BaseMessageText("HACA0007"));
                }
                if (results == 3) {
                    throw new UserProfilesException(new BaseMessageText("HACA000N"));
                }
                if (results == 4) {
                    throw new UserProfilesException(new BaseMessageText("HACA0006"));
                }
                if (results == 5) {
                    throw new UserProfilesException(new BaseMessageText("HACA0007"));
                }
            }
        } else {
            results = this.caseSensitivity ? UserProfilesPluginImpl.isNonStrictPasswordValid(password) : UserProfilesPluginImpl.isNonStrictPasswordValid(password.toUpperCase());
            if (results > 0) {
                if (results == 1) {
                    throw new UserProfilesException(new BaseMessageText("HACA000P"));
                }
                if (results == 2) {
                    throw new UserProfilesException(new BaseMessageText("HACA000O"));
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- validatePassword ");
    }

    public void checkPassword(String userId, String password) {
        Trace.trace(TRACE_MASKT, "checkPassword " + userId + " " + password);
    }

    public static int isNonStrictPasswordValid(String newPassword) {
        Trace.trace(TRACE_MASKT, "-> PasswordValidation.isNonStrictPasswordValid()");
        int result = 0;
        boolean isValid = true;
        boolean oneNumeric = false;
        if (newPassword != null && newPassword.length() > 0) {
            if (newPassword.length() < 4 || newPassword.length() > 8) {
                result = 1;
            } else {
                for (int i = 0; i < newPassword.length() && isValid; ++i) {
                    if (newPassword.charAt(i) >= 'A' && newPassword.charAt(i) <= 'Z' || newPassword.charAt(i) >= 'a' && newPassword.charAt(i) <= 'z' || newPassword.charAt(i) >= '0' && newPassword.charAt(i) <= '9') continue;
                    result = 2;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PasswordValidation.isNonStrictPasswordValid() - " + isValid + ".");
        return result;
    }

    public static int isPasswordValid(String newPassword) {
        Trace.trace(TRACE_MASKT, "-> PasswordValidation.isPasswordValid()");
        boolean isValid = true;
        boolean oneNumeric = false;
        int result = 0;
        if (newPassword != null && newPassword.length() > 0) {
            if (newPassword.length() < 6 || newPassword.length() > 8) {
                result = 1;
            } else if (newPassword.charAt(0) >= '0' && newPassword.charAt(0) <= '9' || newPassword.charAt(newPassword.length() - 1) >= '0' && newPassword.charAt(newPassword.length() - 1) <= '9') {
                result = 2;
            } else {
                for (int i = 0; i < newPassword.length() && isValid; ++i) {
                    if (!(newPassword.charAt(i) >= 'A' && newPassword.charAt(i) <= 'Z' || newPassword.charAt(i) >= 'a' && newPassword.charAt(i) <= 'z' || newPassword.charAt(i) >= '0' && newPassword.charAt(i) <= '9')) {
                        result = 3;
                        continue;
                    }
                    if (i < newPassword.length() - 2 && newPassword.charAt(i) == newPassword.charAt(i + 1) && newPassword.charAt(i + 1) == newPassword.charAt(i + 2)) {
                        result = 4;
                        continue;
                    }
                    if (newPassword.charAt(i) < '0' || newPassword.charAt(i) > '9') continue;
                    oneNumeric = true;
                }
                if (isValid && !oneNumeric) {
                    result = 5;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PasswordValidation.isPasswordValid() - " + isValid + ".");
        return result;
    }

    public void dumpTree(RoleTree myTree) {
        System.out.println("--> userprofilespluginimpl dumptree");
        System.out.println("tree name is " + myTree.getName());
        System.out.println("tree key is " + myTree.getKey());
        System.out.println("tree type is " + myTree.getType());
        System.out.println("tree editable is " + myTree.isEditable());
        System.out.println("tree basedon is " + myTree.getCanBeBasedOn());
        System.out.println("tree childcount is " + myTree.getChildCount());
        System.out.println("tree level is " + myTree.getLevel());
        for (int x = 0; x < myTree.getChildCount(); ++x) {
            RoleItem kid = (RoleItem)myTree.getChildAt(x);
            System.out.println("child is " + kid.getName());
            System.out.println("child key is " + kid.getKey());
            System.out.println("child level is " + kid.getLevel());
        }
        System.out.println("<-- userprofilespluginimpl dumptree");
    }

    public boolean validateString(String data, String whichOne) {
        boolean result = false;
        if (data.length() < 1) {
            throw new UserProfilesException(new LocalizableText("Invalid string " + whichOne));
        }
        result = true;
        return result;
    }

    public static int isUseridValid(String userid) {
        Trace.trace(TRACE_MASKT, "-> UserProfilesPluginImpl.isUseridValid()");
        boolean isValid = true;
        boolean oneNumeric = false;
        int result = 0;
        if (userid != null && userid.length() > 0) {
            if (userid.length() <= 3 || userid.length() > 32) {
                result = 1;
            } else {
                for (int i = 0; i < userid.length() && isValid; ++i) {
                    if (userid.charAt(i) >= 'A' && userid.charAt(i) <= 'Z' || userid.charAt(i) >= 'a' && userid.charAt(i) <= 'z' || userid.charAt(i) >= '0' && userid.charAt(i) <= '9') continue;
                    result = 2;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- UseridValidation.isuseridValid() - " + result + ".");
        return result;
    }

    public List buildObjects(TreeMap newObjects, int type, List curRoles, int path) {
        HwmcaObject obj;
        String roleName;
        int i = 0;
        Trace.trace(TRACE_MASKT, "-> buildObjects type - " + type);
        Set entries = newObjects.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            RoleTree myTree;
            LocalizableText desc;
            roleName = (String)it.next();
            obj = (HwmcaObject)newObjects.get(roleName);
            if (obj instanceof CustomizedUserRole) {
                desc = new LocalizableText(roleName);
                Trace.trace(TRACE_MASKT, "-> customizeduserrole found " + roleName);
                myTree = new RoleTree(((CustomizedUserRole)obj).getObjectId(), desc, null);
                if (path == 1) {
                    if (type == 0) {
                        myTree = this.buildManagedObjectGroups(myTree, (CustomizedUserRole)obj);
                        myTree = this.buildManagedObjects(myTree, (CustomizedUserRole)obj);
                    } else {
                        myTree = this.buildTaskObjects(myTree, (CustomizedUserRole)obj);
                    }
                }
            } else {
                desc = new LocalizableText(roleName);
                myTree = new RoleTree(((UserRole)obj).getObjectId(), desc, null);
                if (path == 1) {
                    if (type == 0) {
                        myTree = this.buildManagedObjectGroups(myTree, (UserRole)obj);
                        myTree = this.buildManagedObjects(myTree, (UserRole)obj);
                    } else {
                        myTree = this.buildTaskObjects(myTree, (UserRole)obj);
                    }
                }
            }
            myTree.setType(type);
            curRoles.add(myTree);
        }
        it = entries.iterator();
        while (it.hasNext()) {
            roleName = (String)it.next();
            obj = (HwmcaObject)newObjects.get(roleName);
            if (obj instanceof CustomizedUserRole) {
                Trace.trace(TRACE_MASKT, "-> customizeduserrole found " + roleName);
                ObjectId basedId = ((CustomizedUserRole)obj).getBasedOnRole();
                if (basedId != null) {
                    RoleTree basedOn = this.findRoleTree(curRoles, basedId);
                    RoleTree curRole = (RoleTree)curRoles.get(i);
                    curRole.setBasedOnRole(basedOn);
                    Trace.trace(TRACE_MASKT, "findRoleTree returned " + basedOn.getName());
                }
            }
            ++i;
        }
        return curRoles;
    }

    public void buildChildObjects(TreeMap newObjects, RoleItem curItem) {
        Trace.trace(TRACE_MASKT, "-> buildChildObjects");
        Set entries = newObjects.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ManagedObject myObject = (ManagedObject)newObjects.get(name);
            String value = this.createKey(myObject.getObjectId());
            RoleItem childItem = new RoleItem(value, new LocalizableText(name));
            curItem.add(childItem);
        }
    }

    public void buildObjectGroups(TreeMap newObjectGroups, RoleItem curItem) {
        Trace.trace(TRACE_MASKT, "-> buildObjectGroups  ");
        Set entries = newObjectGroups.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ManagedObjectGroup myObjectGroup = (ManagedObjectGroup)newObjectGroups.get(name);
            String value = this.createKey(myObjectGroup.getObjectId());
            RoleItem childItem = new RoleItem(value, new LocalizableText(name));
            curItem.add(childItem);
        }
    }

    public Set orderInventory(Set inventory) {
        TreeMap<String, ObjectId> newInventory = new TreeMap<String, ObjectId>();
        HashSet<ObjectId> orderedInv = new HashSet<ObjectId>();
        Trace.trace(TRACE_MASKT, "-> orderInventory(set)  ");
        Trace.trace(TRACE_MASKT, "group size " + inventory.size());
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            ObjectId objId = (ObjectId)iterator.next();
            HwmcaObject obj = this.getProfilesObj(objId);
            newInventory.put(obj.getUIInfo().getTitle(), obj.getObjectId());
        }
        Set entries = newInventory.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ObjectId newObj = (ObjectId)newInventory.get(name);
            orderedInv.add(newObj);
        }
        return orderedInv;
    }

    public List orderInventory(List objectIds) {
        TreeMap<String, ObjectId> newInventory = new TreeMap<String, ObjectId>();
        ArrayList<ObjectId> orderedInv = new ArrayList<ObjectId>();
        Trace.trace(TRACE_MASKT, "-> orderInventory(list) ");
        Trace.trace(TRACE_MASKT, "group size " + objectIds.size());
        for (int i = 0; i < objectIds.size(); ++i) {
            ObjectId objId = (ObjectId)objectIds.get(i);
            HwmcaObject obj = this.getProfilesObj(objId);
            newInventory.put(obj.getUIInfo().getTitle(), objId);
        }
        Set entries = newInventory.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            ObjectId newObj = (ObjectId)newInventory.get(name);
            orderedInv.add(newObj);
        }
        return orderedInv;
    }

    public UserAttributes[] buildUsers(TreeMap realUsers, UserAttributes[] users, int index) {
        Set entries = realUsers.keySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            User myUser = (User)realUsers.get(name);
            String description = myUser.getUIInfo().getCaption();
            byte[] bytePW = myUser.getPassword();
            UserAttributes newData = new UserAttributes(name, bytePW, new LocalizableText(description));
            newData.setCaseSensitive(false);
            users[index] = newData;
            ++index;
        }
        return users;
    }

    public Set buildObjectList(CustomizedUserRole customRole, RoleTree role) {
        HashSet<ObjectId> newObjects = new HashSet<ObjectId>();
        UserDefinedTaskGroup newTaskGroup = null;
        LocalizableText name = role.getName();
        UIInfo uiInfo = new UIInfo(name, name);
        if (customRole.getType() == 0) {
            for (int i = 0; i < role.getChildCount(); ++i) {
                RoleItem roleItem = (RoleItem)role.getChildAt(i);
                if (!roleItem.hasChildren()) continue;
                int kidSize = roleItem.getChildCount();
                for (int x = 0; x < kidSize; ++x) {
                    RoleItem childItem = (RoleItem)roleItem.getChildAt(x);
                    String id = (String)childItem.getKey();
                    id = id.substring(id.lastIndexOf("-") + 1);
                    ObjectId objectId = new ObjectId(id);
                    newObjects.add(objectId);
                }
            }
        } else {
            for (int i = 0; i < role.getChildCount(); ++i) {
                RoleItem roleItem = (RoleItem)role.getChildAt(i);
                String id = (String)roleItem.getKey();
                LocalizableText groupName = roleItem.getName();
                uiInfo = new UIInfo(groupName, groupName);
                String newName = groupName.toString();
                newName = newName + String.valueOf(this.idCounter);
                ++this.idCounter;
                Trace.trace(TRACE_MASKT, "UserDefinedTaskGroup name " + newName);
                Trace.trace(TRACE_MASKT, "UserDefinedTaskGroup uiInfo " + groupName);
                try {
                    newTaskGroup = new UserDefinedTaskGroup(newName, uiInfo);
                    newTaskGroup.setRoot(true);
                    this.mom.add(newTaskGroup);
                }
                catch (Exception exc) {
                    Exception ex = new Exception(exc);
                }
                newObjects.add(newTaskGroup.getObjectId());
                if (!roleItem.hasChildren()) continue;
                int kidSize = roleItem.getChildCount();
                Trace.trace(TRACE_MASKT, "roleItem kidSize " + kidSize);
                for (int x = 0; x < kidSize; ++x) {
                    RoleItem childItem = (RoleItem)roleItem.getChildAt(x);
                    id = (String)childItem.getKey();
                    id = id.substring(id.lastIndexOf("-") + 1);
                    ObjectId objectId = new ObjectId(id);
                    newObjects.add(objectId);
                    newTaskGroup.addChild(objectId);
                    Trace.trace(TRACE_MASKT, "adding ObjectId " + objectId);
                    for (int s = 0; s < childItem.getChildCount(); ++s) {
                        RoleItem subItem = (RoleItem)childItem.getChildAt(s);
                        id = (String)subItem.getKey();
                        id = id.substring(id.lastIndexOf("-") + 1);
                        objectId = new ObjectId(id);
                        newObjects.add(objectId);
                        Trace.trace(TRACE_MASKT, "adding ObjectId " + objectId);
                    }
                }
            }
        }
        this.logRoleEvent(0, name.toString());
        Trace.trace(TRACE_MASKT, "<- addRole roleSize is " + customRole.getPermittedObjects());
        TaskletController.flushCache();
        return newObjects;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

